/* uncompress lh5 data
 *
 * 2003-02-10T06:45:39Z
 */

typedef unsigned int uint;
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

#include <string.h>

/* *ah* loads of global variables */

static u32 blocksize;
static u32 control; /* should be in a register */
static int shift; /* should be in a register */

static u8 *srcbuf, *dstbuf;
static uint src, dst;
static uint srclen, dstlen;

#define SHIFT() { if(shift > 0) { control |= (srcbuf[src] << 8 | srcbuf[src + 1]) << shift; src += 2; shift -= 16; } }
#define BITS(cnt) { bits = control >> (32 - (cnt)); shift += (cnt); control <<= (cnt); }

static u16 lit_codes[8192];
static u16 off_codes[1024];
static u8 lit_lens[512];
static u8 off_lens[32];
static u16 freq[17];
static u16 pref[17];

static int tree0(), tree1(), tree2(), tree3(), tree4();
static int huffman_prefixes();
static void general_tree(u16 *codes, uint base_size, u8 *lens, uint symbol);
static void special_tree(u16 *codes, uint base_size, u8 *lens, uint symbol);

int unlh5(u8 *srcpt, uint srcln, u8 *dstpt, uint dstln)
{
	srcbuf = srcpt;
	srclen = srcln + 6; /* little bit of unavoidable overrun */
	dstbuf = dstpt;
	dstlen = dstln;
	src = 0;
	dst = 0;
	control = 0;
	shift = 16;
	while(src < srclen && dst < dstlen) {
		if(tree0() || tree1() || tree2() || tree3() || tree4()) return(1); /* nasty */
	}
	return(dst != dstlen);
}

static int tree0()
{
	uint bits;
	SHIFT();
	BITS(16); blocksize = bits; SHIFT();
	if(src >= srclen) return(1);
	return(blocksize == 0);
}
static int tree1()
{
	uint bits, i, sym, len;
	BITS(5); sym = bits; SHIFT(); /* number of symbols defined in this tree */
	if(src >= srclen) return(1);
	if(sym == 0) {
		BITS(5); sym = bits; SHIFT();
		if(sym >= 20) return(1);
		special_tree(off_codes, 6, off_lens, sym);
		return(0);
	}
	if(sym >= 20) return(1);
	memset(off_lens, 0, sizeof(off_lens));
	memset(freq, 0, sizeof(freq));
	for(i = 0; i < sym; i++) {
		if(src >= srclen) return(1);
		BITS(3); len = bits;
		while(len >= 7) {
			BITS(1); if(bits == 0) break;
			len++;
			if(len >= 15) return(1);
		}
		SHIFT();
		off_lens[i] = len; freq[len]++;
		if(i == 2) { BITS(2); i += bits; SHIFT(); }
	}
	if(i != sym) return(1);
	if(huffman_prefixes()) return(1);
	memset(off_codes, 0, sizeof(off_codes));
	general_tree(off_codes, 6, off_lens, 20);
	return(0);
}
static int tree2()
{
	uint bits, i, sym, tmp;
	BITS(9); sym = bits; SHIFT(); /* number of symbols defined in this tree */
	if(src >= srclen) return(1);
	if(sym == 0) {
		BITS(9); sym = bits; SHIFT();
		if(sym >= 511) return(1);
		special_tree(lit_codes, 12, lit_lens, sym);
		return(0);
	}
	if(sym >= 511) return(1);
	memset(lit_lens, 0, sizeof(lit_lens));
	memset(freq, 0, sizeof(freq));
	for(i = 0; i < sym; i++) {
		if(src >= srclen) return(1);
		tmp = off_codes[control >> 26];
		if(tmp >= 64) {
			tmp = off_codes[tmp + (control >> 22 & 15)];
			if(tmp >= 64) {
				tmp = off_codes[tmp + (control >> 18 & 15)];
			}
		}
		shift += off_lens[tmp]; control <<= off_lens[tmp];
		SHIFT();
		switch(tmp) {
		case 0: break; /* zero */
		case 1: BITS(4); i += bits + 2; SHIFT(); break; /* zero 3-18 */
		case 2: BITS(9); i += bits + 19; SHIFT(); break; /* zero 20-531 */
		default: tmp -= 2; lit_lens[i] = tmp; freq[tmp]++; break;
		}
	}
	if(i != sym) return(1);
	if(huffman_prefixes()) return(1);
	memset(lit_codes, 0, sizeof(lit_codes));
	general_tree(lit_codes, 12, lit_lens, 510);
	return(0);
}
static int tree3()
{
	uint bits, i, sym, len;
	BITS(4); sym = bits; SHIFT(); /* number of symbols defined in this tree */
	if(src >= srclen) return(1);
	if(sym == 0) {
		BITS(4); sym = bits; SHIFT();
		if(sym >= 15) return(1);
		special_tree(off_codes, 8, off_lens, sym);
		return(0);
	}
	if(sym >= 15) return(1);
	memset(off_lens, 0, sizeof(off_lens));
	memset(freq, 0, sizeof(freq));
	for(i = 0; i < sym; i++) {
		if(src >= srclen) return(1);
		BITS(3); len = bits;
		while(len >= 7) {
			BITS(1); if(bits == 0) break;
			len++;
			if(len >= 17) return(1);
		}
		SHIFT();
		off_lens[i] = len; freq[len]++;
	}
	if(i != sym) return(1);
	if(huffman_prefixes()) return(1);
	memset(off_codes, 0, sizeof(off_codes));
	general_tree(off_codes, 8, off_lens, 15);
	return(0);
}
static int tree4()
{
	uint lit, len, off;
	while(blocksize--) {
		if(src >= srclen || dst >= dstlen) return(1);
		lit = lit_codes[control >> 20];
		if(lit >= 4096) {
			lit = lit_codes[lit + (control >> 16 & 15)];
		}
		shift += lit_lens[lit]; control <<= lit_lens[lit];
		SHIFT();
		if(lit < 256) { dstbuf[dst++] = lit; continue; }
		len = off_codes[control >> 24];
		if(len >= 256) {
			len = off_codes[len + (control >> 20 & 15)];
			if(len >= 256) {
				len = off_codes[len + (control >> 16 & 15)];
			}
		}
		shift += off_lens[len]; control <<= off_lens[len];
		SHIFT();
		if(len < 2) {
			off = len + 1;
		} else {
			len--;
			off = (1u << len | control >> (32 - len)) + 1;
			shift += len; control <<= len;
			SHIFT();
		}
		if(off > dst) return(1);
		off = dst - off;
		lit -= 253;
		while(lit--) dstbuf[dst++] = dstbuf[off++];
	}
	return(0);
}
static int huffman_prefixes()
{
	uint i;
	uint base = 0, left = 1;
	for(i = 1; i < 17; i++) {
		base *= 2; left *= 2;
		pref[i] = base;
		base += freq[i]; left -= freq[i];
	}
	return(left != 0);
}
static void special_tree(u16 *codes, uint base_size, u8 *lens, uint symbol)
{
	uint i;
	for(i = 0; i < (1u << base_size); i++) codes[i] = symbol; lens[symbol] = 0;
}
static void general_tree(u16 *codes, uint base_size, u8 *lens, uint symbol)
{
	uint i;
	uint len, code, base, bits;
	uint alloc;
	alloc = 1u << base_size;
	for(i = 0; i < symbol; i++) {
		len = lens[i];
		if(len == 0) continue;
		code = pref[len]++;
		base = 0;
		bits = base_size;
		while(len > bits) {
			len -= bits;
			base += code >> len;
			code &= (1u << len) - 1;
			bits = 4;
			if(codes[base] == 0) {
				codes[base] = alloc; alloc += 1u << bits;
			}
			base = codes[base];
		}
		if(len < bits) {
			bits -= len;
			base += code << bits;
			for(len = 1u << bits; len--; base++) codes[base] = i;
		} else {
			codes[base + code] = i;
		}
	}
}
