#include "stdafx.h"
#ifndef HDF_H
#define HDF_H

typedef unsigned int uint;
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

#define BE16(a) (u16)((u16)0[a] << 8 | (u16)1[a])
#define BE32(a) (u32)((u32)0[a] << 24 | (u32)1[a] << 16 | (u32)2[a] << 8 | (u32)3[a])

/* structure of hdf file
 * +------------+------------+-----------------------------+
 * | info block | data block | data block [...] data block |
 * +------------+------------+-----------------------------+
 * info block
 * +--------------+------------+-----------+--------------+-----------------+
 * | block header | model type | system id | total blocks | total file size |
 * +--------------+------------+-----------+--------------+-----------------+
 * data block
 * +--------------+-------+---------------------+--------------+-----------------------+
 * | block header | flags | uncompressed length | load address | compressed data [...] |
 * +--------------+-------+---------------------+--------------+-----------------------+
 * block header
 * +-----------------------+----------------------+------------+
 * | total length of block | crc checksum of data | data [...] |
 * +-----------------------+----------------------+------------+
 */

#define HDR_LENGTH(a) BE16((a) + 0) /* total length of block including checksum */
#define HDR_CRC(a) BE16((a) + 2) /* crc-16 checksum of following data */
#define HDR_size 4u

#define BLOCK_IS_INFO(a) (0[a] == 0 && 1[a] == 18)
#define BLOCK_IS_INFO2(a) (0[a] == 0 && 1[a] == 12)

#define INFO_HEADER(a) ((a) + 0)
#define INFO_MODEL(a) BE16((a) + 4) /* 1=non SuperSet 2=SuperSet 3=OAK */
#define INFO_BLOCKS(a) BE16((a) + 6) /* number of data blocks */
#define INFO_ID1(a) BE32((a) + 8)
#define INFO_ID2(a) BE32((a) + 12)
#define INFO_LENGTH(a) BE32((a) + 16) /* total size of data blocks */
#define INFO_size 20u

#define INFO2_HEADER(a) ((a) + 0)
#define INFO2_MODEL(a) BE16((a) + 4)
#define INFO2_ID(a) BE16((a) + 6)
#define INFO2_BLOCKS(a) BE16((a) + 8)
#define INFO2_LENGTH(a) BE32((a) + 10)
#define INFO2_size 14u

#define DATA_HEADER(a) ((a) + 0)
#define DATA_TYPE(a) (BE16((a) + 4) & 32767)
#define DATA_IS_PACKED(a) ((4[a] & 128) != 0)
#define DATA_LENGTH(a) BE16((a) + 6) /* uncompressed length */
#define DATA_PACKLEN(a) (HDR_LENGTH(DATA_HEADER(a)) - 10u) /* compressed length */
#define DATA_ADDRESS(a) BE32((a) + 8) /* load address */
#define DATA_size 12u

#endif
