// UHDFDlg.cpp : implementation file
//

#include "stdafx.h"
#include "UHDF.h"
#include "UHDFDlg.h"
#include "CFolderDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int uhdfmain(CString infile, CString outfile, int blocksize,CString dirfile,int blocksort,int splitblocks,int savehdf);
int maindisasm(unsigned long address, CString infile, CString outfile);

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUHDFDlg dialog

CUHDFDlg::CUHDFDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUHDFDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUHDFDlg)
	m_infile = _T("");
	m_outfile = _T("");
	m_dirfile = _T("pluto");
	m_blocksize = 4096;
	m_sortblocks = TRUE;
	m_splitblock = TRUE;
	m_limitblobk = FALSE;
	m_hdfout = FALSE;
	m_IsHDFInput = TRUE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CUHDFDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUHDFDlg)
	DDX_Text(pDX, IDC_EDIT1, m_infile);
	DDX_Text(pDX, IDC_EDIT2, m_outfile);
	DDX_Text(pDX, IDC_EDIT3, m_dirfile);
	DDX_Text(pDX, IDC_EDIT4, m_blocksize);
	DDV_MinMaxInt(pDX, m_blocksize, 4096, 65536);
	DDX_Check(pDX, IDC_CHECK1, m_sortblocks);
	DDX_Check(pDX, IDC_CHECK2, m_splitblock);
	DDX_Check(pDX, IDC_CHECK3, m_limitblobk);
	DDX_Check(pDX, IDC_CHECK4, m_hdfout);
	DDX_Check(pDX, IDC_CHECK5, m_IsHDFInput);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUHDFDlg, CDialog)
	//{{AFX_MSG_MAP(CUHDFDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_CHECK3, OnCheck3)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck2)
	ON_BN_CLICKED(IDOK2, OnOk2)
	ON_EN_KILLFOCUS(IDC_EDIT1, OnKillfocusEdit1)
	ON_EN_KILLFOCUS(IDC_EDIT2, OnKillfocusEdit2)
	ON_EN_KILLFOCUS(IDC_EDIT4, OnKillfocusEdit4)
	ON_BN_CLICKED(IDC_CHECK4, OnCheck4)
	ON_BN_CLICKED(IDC_CHECK5, OnCheck5)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUHDFDlg message handlers

BOOL CUHDFDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	GetDlgItem(IDC_EDIT1)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON1)->EnableWindow(TRUE);
	GetDlgItem(IDC_EDIT2)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON2)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT3)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT4)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK1)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK2)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK3)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK4)->EnableWindow(FALSE);
	GetDlgItem(IDOK)->EnableWindow(FALSE);
	GetDlgItem(IDOK2)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT2)->EnableWindow(FALSE);
	GetDlgItem(IDC_STATIC1)->EnableWindow(FALSE);
	GetDlgItem(IDC_STATIC2)->EnableWindow(FALSE);
	GetDlgItem(IDC_STATIC3)->EnableWindow(FALSE);
	GetDlgItem(IDC_STATIC4)->EnableWindow(FALSE);
	GetDlgItem(IDC_STATIC6)->EnableWindow(FALSE);
	

	GetDlgItem(IDC_BUTTON3)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON2)->EnableWindow(FALSE);

	//GetDlgItem(IDC_BUTTON)->EnableWindow(FALSE);
	//GetDlgItem(IDC_CHECK3)->EnableWindow(FALSE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CUHDFDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CUHDFDlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CUHDFDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUHDFDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CUHDFDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	CFileDialog* infilename;
	if(m_IsHDFInput)
		infilename = new CFileDialog(TRUE,NULL,m_infile,OFN_EXPLORER|OFN_FILEMUSTEXIST,"HDF Files (*.hdf)|*.hdf|Raw Files (*.raw)|*.raw||",NULL);
	else
		infilename = new CFileDialog(TRUE,NULL,m_infile,OFN_EXPLORER|OFN_FILEMUSTEXIST,"RAW Files (*.raw)|*.raw|HDF Files (*.hdf)|*.hdf||",NULL);

	if (infilename->DoModal()==IDOK){
		m_infile = infilename->GetFileName();
		if (infilename->GetFileExt()=="raw"){
			m_IsHDFInput=FALSE;
			GetDlgItem(IDC_STATIC5)->EnableWindow(FALSE);
			GetDlgItem(IDC_STATIC6)->EnableWindow(TRUE);
		}
		else{
			GetDlgItem(IDC_STATIC5)->EnableWindow(TRUE);
			GetDlgItem(IDC_STATIC6)->EnableWindow(FALSE);
			m_IsHDFInput=TRUE;
		};
		m_dirfile = (infilename->GetPathName());
		m_dirfile.TrimRight(m_infile);
		m_dirfile.TrimRight("\\");
		FILE * infile= fopen(m_infile,"rb");
		if(infile){
			fclose(infile);
			SetWindowText("DataSetAnalyzer - " +  infilename->GetPathName());  // solo il file infilename->GetFileName());
			UpdateData(0);
			
			GetDlgItem(IDC_EDIT2)->EnableWindow(TRUE);
			GetDlgItem(IDC_BUTTON2)->EnableWindow(TRUE);
			GetDlgItem(IDC_EDIT3)->EnableWindow(TRUE);
			GetDlgItem(IDC_CHECK1)->EnableWindow(TRUE);
			GetDlgItem(IDC_CHECK2)->EnableWindow(TRUE);
			GetDlgItem(IDC_CHECK3)->EnableWindow(TRUE);
			GetDlgItem(IDC_CHECK4)->EnableWindow(TRUE);
			GetDlgItem(IDOK)->EnableWindow(TRUE);
			GetDlgItem(IDOK2)->EnableWindow(TRUE);
			if(m_splitblock==TRUE){
				GetDlgItem(IDC_EDIT3)->EnableWindow(TRUE);
				GetDlgItem(IDC_EDIT2)->EnableWindow(FALSE);
				GetDlgItem(IDC_BUTTON3)->EnableWindow(TRUE);
				GetDlgItem(IDC_BUTTON2)->EnableWindow(FALSE);
				GetDlgItem(IDC_STATIC1)->EnableWindow(TRUE);
				GetDlgItem(IDC_STATIC2)->EnableWindow(FALSE);
			}else{
				GetDlgItem(IDC_EDIT3)->EnableWindow(FALSE);
				GetDlgItem(IDC_EDIT2)->EnableWindow(TRUE);
				GetDlgItem(IDC_BUTTON3)->EnableWindow(FALSE);
				GetDlgItem(IDC_BUTTON2)->EnableWindow(TRUE);
				GetDlgItem(IDC_STATIC1)->EnableWindow(FALSE);
				GetDlgItem(IDC_STATIC2)->EnableWindow(TRUE);
			}
			if(m_hdfout==TRUE){
				GetDlgItem(IDC_STATIC3)->EnableWindow(TRUE);
				GetDlgItem(IDC_STATIC4)->EnableWindow(FALSE);
			}else{
				GetDlgItem(IDC_STATIC3)->EnableWindow(FALSE);
				GetDlgItem(IDC_STATIC4)->EnableWindow(TRUE);
			}

		}else{
			AfxMessageBox(" Error while Loading Input File !",MB_ICONSTOP);
		};
	}
	delete infilename;
}

void CUHDFDlg::OnButton2() 
{
	// TODO: Add your control notification handler code here
	
	//out file
	CFileDialog* savefile;
	savefile = new CFileDialog(FALSE,".txt",m_outfile,OFN_EXPLORER,"RAW Files (*.raw)|*.raw|ASM Files (*.asm)|*.asm||",NULL);
	if (savefile->DoModal()==IDOK){
		m_outfile = savefile->GetFileName( );
		m_dirfile = (savefile->GetPathName());
		m_dirfile.TrimRight(m_outfile);
		m_dirfile.TrimRight("\\");
		FILE * outfile= fopen(m_outfile,"wt");
		if(outfile){
			fclose(outfile);
			UpdateData(0);
		}else{
			AfxMessageBox(" Error while Creating Output File !",MB_ICONSTOP);
		};
	}
	delete savefile;	
}

void CUHDFDlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
	
	// working dir
	CFolderDialog* dirfilename;
	CString dire="";
	dirfilename = new CFolderDialog(*dire,1);
	if (dirfilename->DoModal()==IDOK){
		m_dirfile=dirfilename->m_pPath;	
		UpdateData(0);
		}else{
			AfxMessageBox(" Error while Creating Working Dir !",MB_ICONSTOP);
		};
	delete dirfilename;
	

}

void CUHDFDlg::OnCheck3() 
{
	// TODO: Add your control notification handler code here
	
	//blocksize
	UpdateData(1);
	if(m_limitblobk==TRUE){
		GetDlgItem(IDC_EDIT4)->EnableWindow(TRUE);
	}else{
		GetDlgItem(IDC_EDIT4)->EnableWindow(FALSE);
	}
	UpdateData(0);
}

void CUHDFDlg::OnCheck1() 
{
	// TODO: Add your control notification handler code here

	// sort block

	UpdateData(1);
	UpdateData(0);
}



void CUHDFDlg::OnCheck2() 
{
	// TODO: Add your control notification handler code here
	
	//splitfiles
	UpdateData(1);
	if(m_splitblock==TRUE){
		GetDlgItem(IDC_EDIT3)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT2)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON3)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON2)->EnableWindow(FALSE);
		GetDlgItem(IDC_STATIC1)->EnableWindow(TRUE);
		GetDlgItem(IDC_STATIC2)->EnableWindow(FALSE);

	}else{
		GetDlgItem(IDC_EDIT3)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT2)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON3)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON2)->EnableWindow(TRUE);
		GetDlgItem(IDC_STATIC1)->EnableWindow(FALSE);
		GetDlgItem(IDC_STATIC2)->EnableWindow(TRUE);

	}
	UpdateData(0);
}


void CUHDFDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	// HDF to Raw
	uhdfmain(m_infile, m_outfile, (m_limitblobk==TRUE)?m_blocksize:0,m_dirfile,m_sortblocks,(m_splitblock==TRUE)?1:0,(m_hdfout==TRUE)?1:0);
	//CDialog::OnOK();
}

void CUHDFDlg::OnOk2() 
{
	// TODO: Add your control notification handler code here

	// Raw To Asm
	maindisasm(0x180000, m_infile, m_dirfile+"\\"+m_outfile);
	
}

void CUHDFDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CUHDFDlg::OnKillfocusEdit1() 
{
	// TODO: Add your control notification handler code here
	UpdateData(1);
		FILE * infile= fopen(m_infile,"rb");
		if(infile){
			fclose(infile);
			SetWindowText("DataSetAnalyzer - " +  m_infile);  // solo il file infilename->GetFileName());
			UpdateData(0);
			GetDlgItem(IDC_EDIT2)->EnableWindow(TRUE);
			GetDlgItem(IDC_BUTTON2)->EnableWindow(TRUE);
			GetDlgItem(IDC_EDIT3)->EnableWindow(TRUE);
	if(m_splitblock==TRUE){
		GetDlgItem(IDC_EDIT3)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT2)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON3)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON2)->EnableWindow(FALSE);
	}else{
		GetDlgItem(IDC_EDIT3)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT2)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON3)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON2)->EnableWindow(TRUE);

	}

		}else{
			AfxMessageBox(" Error while Loading Input File !",MB_ICONSTOP);
		};

	UpdateData(0);

}

void CUHDFDlg::OnKillfocusEdit2() 
{
	// TODO: Add your control notification handler code here
	UpdateData(1);
		FILE * outfile= fopen(m_outfile,"wt");
		if(outfile){
			fclose(outfile);
			UpdateData(0);
		}else{
			AfxMessageBox(" Error while Creating Output File !",MB_ICONSTOP);
		};

	UpdateData(0);
	
}



void CUHDFDlg::OnKillfocusEdit4() 
{
	// TODO: Add your control notification handler code here
	UpdateData(1);
	UpdateData(0);
}

void CUHDFDlg::OnCheck4() 
{
	// TODO: Add your control notification handler code here

	// output file is raw
	UpdateData(1);
	if(m_hdfout==TRUE){
		GetDlgItem(IDC_STATIC3)->EnableWindow(TRUE);
		GetDlgItem(IDC_STATIC4)->EnableWindow(FALSE);
	}else{
		GetDlgItem(IDC_STATIC3)->EnableWindow(FALSE);
		GetDlgItem(IDC_STATIC4)->EnableWindow(TRUE);
	}
	UpdateData(0);	
}

void CUHDFDlg::OnCheck5() 
{
	// TODO: Add your control notification handler code here
	//blocksize
	UpdateData(1);
	if(m_IsHDFInput==TRUE){
		GetDlgItem(IDC_STATIC5)->EnableWindow(TRUE);
		GetDlgItem(IDC_STATIC6)->EnableWindow(FALSE);
	}else{
		GetDlgItem(IDC_STATIC5)->EnableWindow(FALSE);
		GetDlgItem(IDC_STATIC6)->EnableWindow(TRUE);
	}
	UpdateData(0);	
}
