
// HDISASM
#include "stdafx.h"
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dismips.cpp"


// THANX TO UNDICI77 AND LUIGI FOR THIS ROUTINE :)
#define HEX_NUMERIC_OFFSET	    	0x30
#define HEX_ALPHABETIC_OFFSET		0x37
/******************************************************************************/
unsigned long _hex_to_dec (unsigned char buffer[], unsigned int length)
/******************************************************************************/
{
	unsigned char id;
	unsigned long value;
	unsigned int number;

	value = 0;

 	for (id = 0; id < length; id++)
 	{
		number = buffer[id];

		if (number >= '0' && number <= '9')
			number -= HEX_NUMERIC_OFFSET;
		else if(number >= 'A' && number <= 'F')
			number -= HEX_ALPHABETIC_OFFSET;

		value = (value << 4) + ((unsigned char)number);
 	}
	return (value);
}


// THANX TO UNDICI77 FOR THIS UNINION TRICK, I NEED KERNIGHAN&RITCHIE  :)
//---------------------------------------------------------------------------
typedef union {
   char buf[4];
   unsigned long ulong;
} buf_ulong;


//---------------------------------------------------------------------------
int maindisasm(unsigned long address, CString infile, CString outfile)
{
   FILE *fbin, *fasm;
   buf_ulong data;


   if ( ( fbin = fopen (infile, "rb") ) == NULL ) {
      fprintf(stderr, "unable to open input file");
      return 1;
   };

   if ( ( fasm = fopen (outfile, "wt") ) == NULL ) {
      fprintf(stderr, "unable to open output file");
      return 1;
   };
   //fclose(fasm);

   // WARNING, NO CHECK ON INPUT FILE NAME CONTENT, PARANOIA
   //address = _hex_to_dec( argv[1], 8 );

   fprintf( fasm, "\n\t%s\n\n", ".set noreorder" );

   data.buf[3] = fgetc(fbin);
   data.buf[2] = fgetc(fbin);
   data.buf[1] = fgetc(fbin);
   data.buf[0] = fgetc(fbin);

   while (!feof(fbin)) {
//fasm = fopen (outfile, "at");
      fprintf( fasm, "\t%s\t\t",  mips_disass(address, data.ulong ) );
      fprintf( fasm, "# 0x%8.8x\n", data.ulong );
//fclose(fasm);
      data.buf[3] = fgetc(fbin);
      data.buf[2] = fgetc(fbin);
      data.buf[1] = fgetc(fbin);
      data.buf[0] = fgetc(fbin);

      address += 4;
   };

   fclose(fasm);
   fclose(fbin);

   return 0;
}
